import numpy as np
from PIL import Image, ImageDraw
import os

#this script generates model geometries for Fluosim mimicking axonal actin rings in 2D

path = r'/Users/jakobrentsch/FU Box/Papers/Stripes/JCB/Resubmission/Data/Scripts and raw data/Figure 1/g'

absolut_x_offset = 1000
absolut_y_offset = 1000
distance_rings = 200;
num_rings = 10;
extra_length_axon = 0;

outline = [absolut_x_offset, absolut_y_offset, absolut_x_offset+(1+num_rings)*distance_rings+extra_length_axon, absolut_y_offset, absolut_x_offset+(1+num_rings)*distance_rings + extra_length_axon, absolut_y_offset +500, absolut_x_offset, absolut_y_offset +500]
canvas = [absolut_x_offset+(1+num_rings)*distance_rings+extra_length_axon+2000, 2500]
canvas_bg = [int(np.ceil(absolut_x_offset+(1+num_rings)*distance_rings+extra_length_axon+2000)/100), int(np.ceil(2500/100))]

im = Image.new('RGB', canvas)
draw = ImageDraw.Draw(im)

draw.polygon(outline)


size = 20
x = 0

final_array = np.zeros((num_rings*distance_rings, 8))

for j in range (int(extra_length_axon/2), num_rings*distance_rings + int(extra_length_axon/2), distance_rings):
    offx = absolut_x_offset + distance_rings + j

    b = ((offx, absolut_y_offset), (offx + size, absolut_y_offset), (offx + size, absolut_y_offset + 500), (offx, absolut_y_offset + 500))
    draw.polygon(b)

    final_array[x] = np.array([offx, absolut_y_offset, offx + size, absolut_y_offset, offx + size, absolut_y_offset + 500, offx, absolut_y_offset + 500])/100
    x += 1


im.show(im)

output_name = "actin-model_width-of-actin=" + str(size)

outline = np.array(outline)/100

if os.path.isfile(path + '/' + output_name + '.rgn'):
    os.remove(path + '/' + output_name + '.rgn')

outline_row = "0 3, 1 16711680, 2 0 0, 3 0 0, 4 0, 5 1, 6 4 "
for i in range(0, 8):
    outline_row = outline_row + str(outline[i]) + " "
outline_row = outline_row + ",7 1"

with open(path + '/' + output_name + '.rgn', 'a') as the_file:
    the_file.write(outline_row + '\n')


for j in range(0, num_rings):
    new_row = "0 3, 1 16711680, 2 0 0, 3 0 0, 4 0, 5 1, 6 4 "

    for i in range(0, 8):
        new_row = new_row + str(final_array[j, i]) + " "
    new_row = new_row + ",7 1"
    with open(path + '/' + output_name + '.rgn', 'a') as the_file:
        the_file.write(new_row + '\n')


im.save(path + '/' + output_name + ".png")

#export background image to import into Fluosim
background = Image.new('RGB', canvas_bg)
background.save(path + '/' + output_name + '_background' + ".png")